clear;
clc;
//WINDOWS 10 64-BIT OS , Scilab and toolbox versions 6.1.0.

//This experiment is compare the various partition allocation algorithms used by the operating system for memory allocation 
//    1. First-Fit Memory Allocation  2. Best-Fit Memory Allocation 3. Worst-Fit Memory Allocation 

// loading all the necessary functions 
exec("first_fit_func.sci");
exec("best_fit_func.sci");
exec("worst_fit_func.sci");
exec("display_func.sci");

// Example problem 
p = [90 20 50 200];// Defining sample Process Size
b = [50 100 90 200 60];// Defining sample Block Size


//Determining the number of processes and blocks

size_process = size(p);     // Size of the process array is calculated using size() function 
size_process = size_process(2);

size_block = size(b);       // Size of the block array is calculated using size() function
size_block = size_block(2);

/*calling the function, defined in first fit.sci, for first fit allocation*/
ff_allot = firstFit(p,b,size_process,size_block)

/*calling the function, defined in best fit.sci, for best fit allocation*/
bf_allot = bestFit(p, b, size_process, size_block)

/*calling the function, defined in worst fit.sci, for worst fit allocation*/
wf_allot = worstFit(p,b,size_process,size_block);


ff_allotsize = zeros(1,size_process);   //ff_allotsize - size of the selected blocks for first fit
bf_allotsize = zeros(1,size_process);   //bf_allotsize - size of the selected blocks for best fit
wf_allotsize = zeros(1,size_process);   //wf_allotsize - size of the selected blocks for worst fit

// storing the allocated block size for each process according to the respective fits 

for i=1:size_process
    if ff_allot(i)~=0 then                      // checking if any block is selected
        ff_allotsize(i) = b(ff_allot(i));       // storing the size of the selected block for first fit
    else
        ff_allotsize(i) = 0                     // store size as 0 if no block is selected
    end,
    
    if bf_allot(i)~=0 then                      // checking if any block is selected
        bf_allotsize(i) = b(bf_allot(i));       // storing the size of the selected block for best fit
    else
        bf_allotsize(i) = 0                     // store size as 0 if no block is selected
    end, 
    
    if wf_allot(i)~=0 then                      // checking if any block is selected
        wf_allotsize(i) = b(wf_allot(i));       // storing the size of the selected block for worst fit
    else
        wf_allotsize(i) = 0;                    // store size as 0 if no block is selected
    end,
end


//constructing a matrix(y) for graphical representation of first fit, best fit and worst fit

y= zeros(size_process,3);           

y(:,1) = ff_allotsize;       //  First fit allotment size 
y(:,2) = bf_allotsize;       //  Best fit allotment size
y(:,3) = wf_allotsize;       //  Worst fit allotment size

bar(y) // plotting a bar graph

xtitle("Comparison of Various Partition Allocation Algorithm","Process Number","Block Size");
legend("First Fit" , "Best Fit", "Worst Fit" );


//printing first fit, best fit and worst fit array

mprintf("Comparison of Various Partition Allocation Algorithms using Scilab\n\n")    //displaying the title of experiment
mprintf("Ex: Process size P1=90, P2=20, P3=50, P4=200");                             //displaying the sample Process size considered for the of experiment
mprintf("\n    Block or hole size B1= 50, B2= 100, B3=90, B4=200\n");                //displaying the sample Block size considered for the of experiment  

mprintf("\nFIRST FIT:\n")
mprintf("Process no. \tProcess size\tBlock no. Block size\n")
display(ff_allot,ff_allotsize,size_process,p)         //displaying the process and block allocation by first fit array

mprintf("\nBEST FIT:\n")
mprintf("Process no. \tProcess size\tBlock no. Block size\n")
display(bf_allot,bf_allotsize,size_process,p)           //displaying the process and block allocation by best fit array


mprintf("\nWORST FIT:\n")
mprintf("Process no. \tProcess size\tBlock no. Block size\n")
display(wf_allot,wf_allotsize,size_process,p)            //displaying the process and block allocation by worst fit array


